<?php
/* --------------------------------------------------------------
 routes.php 2020-03-10
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

use Gambio\Core\Configuration\Action\SaveConfigurations;
use Gambio\Admin\ParcelService\ParcelServiceController;
use Slim\App;

return function (App $app) {
    $app->post('/conf/save', SaveConfigurations::class);
    
    $app->get('/parcel-services', ParcelServiceController::class . ':showOverview');
    $app->get('/api/parcel-services', ParcelServiceController::class . ':getParcelServices');
    $app->post('/api/parcel-services', ParcelServiceController::class . ':createParcelService');
    $app->put('/api/parcel-services', ParcelServiceController::class . ':updateParcelService');
    $app->delete('/api/parcel-services/{id:[0-9]+}', ParcelServiceController::class . ':deleteParcelService');
};
